@echo off
setlocal EnableExtensions EnableDelayedExpansion

rem ------------------------------------------------------------
rem  Verificateur Python - admin, etapes avec PAUSE, pas de PowerShell
rem  - Ajout permanent au PATH SYSTEME
rem  - pip via ensurepip
rem  - Fenetre conservee ouverte en fin d'execution
rem ------------------------------------------------------------

rem [0] Controle des droits administrateur (auto-elevation si besoin)
fsutil dirty query %systemdrive% >nul 2>&1
if errorlevel 1 (
  echo [0] Droits administrateur requis. Demande d'elevation UAC...
  echo [0] Acceptez l'invite UAC puis revenez ici.
  mshta "vbscript:CreateObject(\"Shell.Application\").ShellExecute(\"%~fs0\",\"\",\"\",\"runas\",1)(close)"
  exit /b
)
echo [0] Execution en mode administrateur : OK.
pause

set "PYTHON_EXE="

echo [1] Recherche de python dans le PATH...
where python >nul 2>&1
if %errorlevel%==0 (
  set "PYTHON_EXE=python"
  goto :python_trouve
)

echo [1] Python non trouve dans le PATH. Scan des emplacements courants...

rem Priorite a C:\Python si present
if exist "C:\Python\python.exe" (
  set "PYTHON_EXE=C:\Python\python.exe"
  call :AjouterAuPathSysteme "C:\Python"
  call :AjouterAuPathSysteme "C:\Python\Scripts"
  goto :python_trouve
)

rem Installation tous utilisateurs (Program Files)
for /d %%D in ("C:\Program Files\Python*") do (
  if exist "%%~fD\python.exe" (
    set "PYTHON_EXE=%%~fD\python.exe"
    call :AjouterAuPathSysteme "%%~fD"
    call :AjouterAuPathSysteme "%%~fD\Scripts"
    goto :python_trouve
  )
)

rem Installation par utilisateur
for /d %%D in ("%LocalAppData%\Programs\Python\Python*") do (
  if exist "%%~fD\python.exe" (
    set "PYTHON_EXE=%%~fD\python.exe"
    call :AjouterAuPathSysteme "%%~fD"
    call :AjouterAuPathSysteme "%%~fD\Scripts"
    goto :python_trouve
  )
)

rem Shim WindowsApps (Microsoft Store)
if exist "%UserProfile%\AppData\Local\Microsoft\WindowsApps\python.exe" (
  set "PYTHON_EXE=%UserProfile%\AppData\Local\Microsoft\WindowsApps\python.exe"
  call :AjouterAuPathSysteme "%UserProfile%\AppData\Local\Microsoft\WindowsApps"
  goto :python_trouve
)

rem Lanceur py (fallback)
where py >nul 2>&1
if %errorlevel%==0 (
  for /f "usebackq delims=" %%P in (`py -0p 2^>nul`) do (
    set "PYTHON_EXE=%%P"
    if exist "!PYTHON_EXE!" (
      for %%F in ("!PYTHON_EXE!") do (
        call :AjouterAuPathSysteme "%%~dpF"
        call :AjouterAuPathSysteme "%%~dpF\Scripts"
      )
      goto :python_trouve
    )
  )
)

echo [1] ERREUR : Python est introuvable. Installez Python puis relancez ce script.
pause
goto :fin_interactif

:python_trouve
echo [1] Utilisation de : "%PYTHON_EXE%"
for %%F in ("%PYTHON_EXE%") do set "PYDIR=%%~dpF"
call :AjouterAuPathSession "%PYDIR%"
if exist "%PYDIR%\Scripts" call :AjouterAuPathSession "%PYDIR%\Scripts"
echo [1] PATH prepare (session + systeme).
pause

echo [2] Verification de pip...
"%PYTHON_EXE%" -m pip --version >nul 2>&1
if errorlevel 1 (
  echo [2] pip non detecte. Execution : python -m ensurepip --upgrade
  "%PYTHON_EXE%" -m ensurepip --upgrade
) else (
  echo [2] pip est deja installe.
)
"%PYTHON_EXE%" -m pip --version >nul 2>&1
if not errorlevel 1 (
  echo [2] Mise a jour de pip vers la derniere version disponible...
  "%PYTHON_EXE%" -m pip install --upgrade pip
) else (
  echo [2] AVERTISSEMENT : pip reste indisponible. Reinstaller Python avec le composant pip si necessaire.
)
pause

echo [3] Affichage des versions...
"%PYTHON_EXE%" --version
"%PYTHON_EXE%" -m pip --version 2>nul
echo [3] OK : Python est installe et fonctionnel si la version s'affiche ci-dessus.
pause

echo [4] Fin du script. La fenetre va rester ouverte sur une invite de commandes.
pause

:fin_interactif
cmd /k

rem ====== FONCTIONS ======

rem Ajout permanent d'un dossier au PATH SYSTEME (admin)
:AjouterAuPathSysteme
set "DIR_AJOUT=%~1"
if not exist "%DIR_AJOUT%" goto :eof

set "PATH_SYS_ACTUEL="
for /f "tokens=2,* skip=2" %%A in ('reg query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v Path 2^>nul') do set "PATH_SYS_ACTUEL=%%B"

set "BESOIN_AJOUT=1"
if defined PATH_SYS_ACTUEL (
  echo ;!PATH_SYS_ACTUEL!; | find /I ";%DIR_AJOUT%;" >nul
  if not errorlevel 1 set "BESOIN_AJOUT=0"
)

if "!BESOIN_AJOUT!"=="1" (
  if defined PATH_SYS_ACTUEL (
    set "NOUVEAU_PATH_SYS=!PATH_SYS_ACTUEL!;%DIR_AJOUT%"
  ) else (
    set "NOUVEAU_PATH_SYS=%DIR_AJOUT%"
  )
  echo [PATH] Ajout au PATH SYSTEME : %DIR_AJOUT%
  setx /M Path "!NOUVEAU_PATH_SYS!" >nul
) else (
  echo [PATH] Deja present dans le PATH SYSTEME : %DIR_AJOUT%
)
goto :eof

rem Ajout au PATH de la session courante (pour utilisation immediate)
:AjouterAuPathSession
set "DIR_AJOUT=%~1"
echo ;%PATH%; | find /I ";%DIR_AJOUT%;" >nul
if errorlevel 1 (
  set "PATH=%PATH%;%DIR_AJOUT%"
  echo [PATH] Ajout au PATH session : %DIR_AJOUT%
) else (
  echo [PATH] Deja present dans le PATH session : %DIR_AJOUT%
)
goto :eof
